// Viscosity Clone by PyThrrrown
// https://www.shadertoy.com/view/7ldXDs
// Created by Alex Kluchikov viscosity klk
// tweaked by PyThrrrone
//

uniform vec3      iResolution;           // viewport resolution (in pixels)
uniform float     iTime;                 // shader playback time (in seconds)
uniform float     iTimeDelta;            // render time (in seconds)
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.
uniform sampler2D iChannel0;
uniform int       iFrame;                // shader playback frame
uniform float     iChannelTime[4];       // channel playback time (in seconds)
uniform vec3      iChannelResolution[4]; // channel resolution (in pixels)
uniform vec4      iMouse;                // mouse pixel coords. xy: current (if MLB down), zw: click
//uniform samplerXX iChannel0..3;          // input channel. XX = 2D/Cube
uniform vec4      iDate;                 // (year, month, day, time in seconds)
uniform float     iSampleRate;           // sound sample rate (i.e., 44100)


#define iResolution u_WindowSize
#define iTime          u_Elapsed*0.31416
#define PI 3.141592654
#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )




vec2 rot(vec2 p,float a)
{
    float c=sin(a*35.83);
    float s=cos(a*35.83);
    return p*mat2(s,c,c,-s);
}
void main( void )
// void mainImage(out vec4 o, in vec2 uv)
{
float s = min(iResolution.x, iResolution.y);

// vec2 uv = iResolution.xy;
 vec2 uv =(2.*gl_FragCoord.xy - vec2(iResolution.x))/ s;
 uv=vec2(.125,.75)+(uv-vec2(.125,.5))*.003;
  //  uv=vec2(.125,.75)+(uv-vec2(.125,.5))*.003;
    float T=iTime*.1;

    vec3 c = clamp(1.-.7*vec3(
        length(uv-vec2(1.1,1)),
        length(uv-vec2(1.1,1)),
        length(uv-vec2(1.1,1))
        ),0.,1.)*2.-1.;
    vec3 c0=vec3(0);
    float w0=0.;
    const float N=5.;
    for(float i=0.;i<N;i++)
    {
        float wt=(i*i/N/N-.2)*.3;
        float wp=0.5+(i+1.)*(i+1.5)*0.000001;
        float wb=.05+i/N*0.1;
    	c.zx=rot(c.zx,1.6+T*0.65*wt+(uv.x+.7)*23.*wp);
    	c.xy=rot(c.xy,c.z*c.x*wb+1.7+T*wt+(uv.y+1.1)*15.*wp);
    	c.yz=rot(c.yz,c.x*c.y*wb+2.4-T*0.79*wt+(uv.x+uv.y*(fract(i/2.)-0.25)*4.)*17.*wp);
    	c.zx=rot(c.zx,c.y*c.z*wb+1.6-T*0.65*wt+(uv.x+.7)*23.*wp);
    	c.xy=rot(c.xy,c.z*c.x*wb+1.7-T*wt+(uv.y+1.1)*15.*wp);
        float w=(1.5-i/N);
        c0+=c*w;
        w0+=w;
    }
    c0=c0/w0*2.+.5;//*(1.-pow(uv.y-.5,2.)*2.)*2.+.5;
    c0*=.5+dot(c0,vec3(1,1,1))/sqrt(3.)*.5;
    c0+=pow(length(sin(c0*PI*4.))/sqrt(3.)*1.0,20.)*(.3+.7*c0);
	gl_FragColor = vec4(c0,1.0);
}
